﻿using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

using System.Media;
using Microsoft.Win32;
using System.IO;
using WMPLib;

namespace Choinka
{
    public partial class Form1 : Form
    {
        private Bitmap obraz = null;
        //private SoundPlayer sp = new SoundPlayer("Choinka.wav");
        WindowsMediaPlayer wmp = new WindowsMediaPlayer();

        public Form1()
        {
            InitializeComponent();            
            
            obraz = new Bitmap("Choinka.png");
            obraz.MakeTransparent(Color.Fuchsia);
            this.Width = obraz.Width;
            this.Height = obraz.Height;

            czytajUstawienia();

            //wmp.PlayStateChange += Wmp_PlayStateChange;
            wmp.MediaError += Wmp_MediaError;
            wmp.URL = "Choinka.mp3";
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            if (!wyciszToolStripMenuItem.Checked)
            {
                //sp.Play();
                wmp.controls.play();
            }
        }

        private void Wmp_MediaError(object pMediaObject)
        {
            MessageBox.Show("Błąd podczas odtwarzania dźwięku", "Choinka", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private void Wmp_PlayStateChange(int NewState)
        {
            /*
            if(NewState == (int)WMPLib.WMPPlayState.wmppsMediaEnded)
            {
                wmp.controls.stop();
                wmp.controls.currentPosition = 0.0;
                if(odtwarzajWPetliToolStripMenuItem.Checked) wmp.controls.play();
            }
            */
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //sp.Stop();
            wmp.controls.stop();
            notifyIcon1.Visible = false;
            if(!czyUkryty) for (; Opacity > 0; Opacity-=0.01) System.Threading.Thread.Sleep(10);
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
            //if (e.KeyChar == (char)27) this.Close();
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Escape: this.Close(); break;
                case Keys.Space: ukryjToolStripMenuItem_Click(null, null); break;
            }
        }

        private bool czyTrwaPrzenoszenie = false;
        private int x0, y0;

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                czyTrwaPrzenoszenie = true;
                x0 = e.X;
                y0 = e.Y;
                this.Cursor = Cursors.Hand;
            }
            if (e.Button == MouseButtons.Middle)
            {
                contextMenuStrip1.Show(this.Location.X+e.Location.X,this.Location.Y+e.Location.Y);
            }
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                Left += e.X - x0;
                Top += e.Y - y0;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                czyTrwaPrzenoszenie = false;
                this.Cursor = Cursors.Default;
            }
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void zawszeWidocznedToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.TopMost = zawszeWidocznedToolStripMenuItem.Checked;
        }

        private void przezroczystośćToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Opacity = przezroczystośćToolStripMenuItem.Checked?0.5:1.0;
        }

        private void usuńZPaskaZadańToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.ShowInTaskbar = !usuńZPaskaZadańToolStripMenuItem.Checked;
        }

        private bool czyUkryty = false;

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!czyUkryty)
            {
                czyUkryty = true;
                this.Hide();
                ukryjToolStripMenuItem.Text = "Pokaż";
            }
            else
            {
                czyUkryty = false;
                this.Show();
                ukryjToolStripMenuItem.Text = "Ukryj";
            }
        }

        private void stronaPSPiZKNETToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //System.Diagnostics.Process.Start("Choinka.png");
            System.Diagnostics.Process.Start("http://pspizk.fizyka.umk.pl");
        }

        private void stronaUMKToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.umk.pl/");
        }

        private void autorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.fizyka.umk.pl/~jacek");
        }

        //private bool czyPodwojneKlikniecie = false;

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            /*
            //MessageBox.Show(czyPodwojneKlikniecie.ToString());            
            System.Threading.Thread.Sleep(500);
            //MessageBox.Show(czyPodwojneKlikniecie.ToString());

            if (e.Button == MouseButtons.Left && !czyPodwojneKlikniecie) ukryjToolStripMenuItem_Click(null, null);
            czyPodwojneKlikniecie = false;
            */
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            //if (e.Button == MouseButtons.Left) czyPodwojneKlikniecie = true;

            notifyIcon1.BalloonTipIcon = ToolTipIcon.None;
            notifyIcon1.BalloonTipText = "Wesołych Świąt i szczęśliwego Nowe Roku " + (DateTime.Now.Year + 1).ToString() + "!\n" + przygotujŁańcuchIleDni();
            notifyIcon1.BalloonTipTitle = "Choinka " + DateTime.Now.Year.ToString();
            notifyIcon1.ShowBalloonTip(5000);
        }

        const string nazwaKluczaRejestruRun = @"Software\Microsoft\Windows\CurrentVersion\Run";

        private void uruchamiajAutomatycznieToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (uruchamiajAutomatycznieToolStripMenuItem.Checked)
                {
                    RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(nazwaKluczaRejestruRun, true);
                    if (kluczRejestruRun.GetValueNames().Contains("Choinka")) kluczRejestruRun.DeleteValue("Choinka");
                    kluczRejestruRun.SetValue("Choinka", "\"" + Application.ExecutablePath + "\"");
                    kluczRejestruRun.Close();
                    //MessageBox.Show("Dodano zapis w rejestrze");
                }
                else
                {
                    RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(nazwaKluczaRejestruRun, true);
                    if (kluczRejestruRun.GetValueNames().Contains("Choinka")) kluczRejestruRun.DeleteValue("Choinka");
                    //MessageBox.Show("Usunięto zapis w rejestrze");
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show("Dodanie zapisu w rejestrze nie powiodło się.\nBłąd: " + exc.Message, "Choinka", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

        }

        private bool czyWłączoneAutouruchamianie()
        {
            RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(nazwaKluczaRejestruRun, true);
            return kluczRejestruRun.GetValueNames().Contains("Choinka");
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            if (!wyciszToolStripMenuItem.Checked)
                //sp.Play();
                wmp.controls.play();
            else
                //sp.Stop();
                wmp.controls.stop();
        }

        private void wybierzDzwiekToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if(openFileDialog1.ShowDialog()==DialogResult.OK)
            {
                string nazwaPliku = openFileDialog1.FileName;
                if (File.Exists(nazwaPliku))
                {
                    //sp.Stop();
                    //sp.SoundLocation = nazwaPliku;
                    wmp.controls.stop();
                    wmp.URL = nazwaPliku;
                    try
                    {
                        //sp.Play();
                        wmp.controls.play();
                    }
                    catch(Exception exc)
                    {
                        MessageBox.Show("Błąd: " + exc.Message, "Choinka", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
            }
        }

        private string przygotujŁańcuchIleDni()
        {
            DateTime teraz = DateTime.Now;
            DateTime wigilia = new DateTime(teraz.Year, 12, 24);
            DateTime sylwester = new DateTime(teraz.Year, 12, 31);
            if (teraz < wigilia)
            {
                int iloscDniDoWigilii = (wigilia - teraz).Days;
                return "Do Wigilii zostało jeszcze " + iloscDniDoWigilii + " dni";
            }
            else
            {
                int iloscDniDoSylwestra = (sylwester - teraz).Days;
                return "Do Sylwestra zostało jeszcze " + iloscDniDoSylwestra + " dni";
            }
        }

        private void pokazZyczeniaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1_MouseDoubleClick(sender, null);
        }

        private void odtwarzajWPetliToolStripMenuItem_Click(object sender, EventArgs e)
        {
            wmp.settings.setMode("loop", odtwarzajWPetliToolStripMenuItem.Checked);
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            notifyIcon1.Text = przygotujŁańcuchIleDni();
        }

        private void contextMenuStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            zapiszUstawienia();
        }

        private void zapiszUstawienia()
        {
            Properties.Settings s = Properties.Settings.Default;
            s.ZawszeWidoczne = zawszeWidocznedToolStripMenuItem.Checked;
            s.Przezroczystosc = przezroczystośćToolStripMenuItem.Checked;
            s.UsunZPaskaZadan = usuńZPaskaZadańToolStripMenuItem.Checked;
            s.OdtwarzajWPetli = odtwarzajWPetliToolStripMenuItem.Checked;
            s.Wycisz = wyciszToolStripMenuItem.Checked;
            s.X = this.Left;
            s.Y = this.Top;
            s.Save();
        }

        private void czytajUstawienia()
        {
            Properties.Settings s = Properties.Settings.Default;
            zawszeWidocznedToolStripMenuItem.Checked = s.ZawszeWidoczne;
            przezroczystośćToolStripMenuItem.Checked = s.Przezroczystosc;
            usuńZPaskaZadańToolStripMenuItem.Checked = s.UsunZPaskaZadan;
            odtwarzajWPetliToolStripMenuItem.Checked = s.OdtwarzajWPetli;
            wyciszToolStripMenuItem.Checked = s.Wycisz;

            zawszeWidocznedToolStripMenuItem_Click(null, EventArgs.Empty);
            przezroczystośćToolStripMenuItem_Click(null, EventArgs.Empty);
            usuńZPaskaZadańToolStripMenuItem_Click(null, EventArgs.Empty);
            odtwarzajWPetliToolStripMenuItem_Click(null, EventArgs.Empty);

            uruchamiajAutomatycznieToolStripMenuItem.Checked = czyWłączoneAutouruchamianie();

            this.Left = s.X;
            this.Top = s.Y;
        }
    }
}
